package com.biz.crm.kms.admin.web;

import lombok.extern.slf4j.Slf4j;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.Banner;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.Environment;
import org.springframework.data.elasticsearch.repository.config.EnableElasticsearchRepositories;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import springfox.documentation.swagger2.annotations.EnableSwagger2WebMvc;

@MapperScan(value = {"com.biz.crm.**.mapper*"})
@EnableFeignClients(basePackages = "com.biz.crm.*")
@SpringBootApplication(scanBasePackages = {"com.biz.crm.*", "com.bizunited.nebula.*"})
@EnableTransactionManagement
@EnableSwagger2WebMvc
@Slf4j
@EnableDiscoveryClient
@EnableAsync
@EnableElasticsearchRepositories(basePackages = "com.biz.crm.**.repository")
public class KmsWebBootstrap {
    public static void main(String[] args) {
        System.setProperty("es.set.netty.runtime.available.processors", "false");
        ConfigurableApplicationContext application = new SpringApplicationBuilder(KmsWebBootstrap.class).bannerMode(Banner.Mode.OFF).web(WebApplicationType.SERVLET).run(args);
        Environment env = application.getEnvironment();
        String port = env.getProperty("server.port");
        String path = env.getProperty("server.servlet.context-path");
        log.info("\n----------------------------------------------------------\n\t" +
                "Application crm-kms is running! Access URLs:\n\t" +
                "本地访问地址: \t\thttp://localhost:" + port + path + "/\n\t" +
                "swagger-ui地址: \t\thttp://localhost:" + port + path + "/swagger-ui.html\n\t" +
                "swagger地址: \t\thttp://localhost:" + port + path + "/doc.html\n" +
                "----------------------------------------------------------");
    }

}
