package com.biz.crm.kms.admin.web.dataview;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import org.springframework.stereotype.Component;

/**
 * KMS直营客户账号数据视图注册器
 *
 * @author zhengbo
 * @date 2022/10/10
 */
@Component
public class DirectAccountDataViewRegister implements DataviewRegister {

    @Override
    public String code() {
        return "kms_direct_account_data_view";
    }

    @Override
    public String desc() {
        return "KMS直营客户账号数据视图";
    }

    @Override
    public String buildSql() {
        return  "SELECT kda.*,kd.business_format_code,kd.business_unit_code,kd.sales_org_code " +
                "FROM kms_direct_account kda " +
                "LEFT JOIN kms_direct kd on kda.direct_code = kd.direct_code " +
                "AND kd.del_flag = '"+ DelFlagStatusEnum.NORMAL.getCode() + "' " +
                "WHERE kda.tenant_code = :tenantCode " +
                "And kda.direct_code = :directCode " +
                "AND kda.del_flag = '"+ DelFlagStatusEnum.NORMAL.getCode() + "' ";
    }
}
