package com.biz.crm.kms.admin.web.dataview;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import org.springframework.stereotype.Component;

/**
 * KMS系统数据视图注册器
 *
 * @author zhengbo
 * @date 2022/10/9
 */
@Component
public class DirectDataViewRegister implements DataviewRegister {

    @Override
    public String code() {
        return "kms_direct_data_view";
    }

    @Override
    public String desc() {
        return "KMS系统数据视图";
    }

    @Override
    public String buildSql() {
        return  "SELECT kd.*,ks.supermarket_name FROM kms_direct kd " +
                "LEFT JOIN kms_supermarket ks ON kd.supermarket_code = ks.supermarket_code " +
                "AND ks.del_flag = '"+ DelFlagStatusEnum.NORMAL.getCode() + "' " +
                "WHERE kd.tenant_code = :tenantCode " +
                "AND kd.del_flag = '"+ DelFlagStatusEnum.NORMAL.getCode() + "' ";
    }
}
