package com.biz.crm.kms.admin.web.dataview;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import org.springframework.stereotype.Component;

/**
 * KMS直营上架商品数据视图注册器
 *
 * @author zhengbo
 * @date 2022/10/10
 */
@Component
public class DirectProductDataViewRegister implements DataviewRegister {

    @Override
    public String code() {
        return "kms_direct_product_data_view";
    }

    @Override
    public String desc() {
        return "KMS直营上架商品数据视图";
    }

    @Override
    public String buildSql() {
        return  "SELECT kdp.*,kd.sales_org_code " +
                "FROM kms_direct_product kdp " +
                "LEFT JOIN kms_direct kd on kdp.direct_code = kd.direct_code " +
                "AND kd.del_flag = '"+ DelFlagStatusEnum.NORMAL.getCode() + "' " +
                "WHERE kdp.tenant_code = :tenantCode " +
                "And kdp.direct_code = :directCode " +
                "AND kdp.del_flag = '"+ DelFlagStatusEnum.NORMAL.getCode() + "' ";
    }
}
