package com.biz.crm.kms.admin.web.dataview;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import org.springframework.stereotype.Component;

/**
 * KMS直营门店数据视图注册器
 *
 * @author zhengbo
 * @date 2022/10/10
 */
@Component
public class DirectStoreDataViewRegister implements DataviewRegister {

    @Override
    public String code() {
        return "kms_direct_store_data_view";
    }

    @Override
    public String desc() {
        return "KMS直营门店数据视图";
    }

    @Override
    public String buildSql() {
        return  "SELECT kds.*,kss.store_name,kd.business_format_code,kd.business_unit_code,kd.sales_org_code " +
                "FROM kms_direct_store kds " +
                "LEFT JOIN kms_direct kd ON kds.direct_code = kd.direct_code " +
                "AND kd.del_flag = '"+ DelFlagStatusEnum.NORMAL.getCode() + "' " +
                "LEFT JOIN kms_supermarket_store kss ON kds.supermarket_store_code = kss.store_code " +
                "AND kd.supermarket_code = kss.supermarket_code " +
                "AND kss.del_flag = '"+ DelFlagStatusEnum.NORMAL.getCode() + "' " +
                "WHERE kds.tenant_code = :tenantCode " +
                "And kds.direct_code = :directCode " +
                "AND kds.del_flag = '"+ DelFlagStatusEnum.NORMAL.getCode() + "' ";
    }
}
