package com.biz.crm.kms.admin.web.dataview;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import org.springframework.stereotype.Component;

/**
 * KMS单据抓取规则数据视图注册器
 *
 * @author zhengbo
 * @date 2022/10/10
 */
@Component
public class GrabRuleDataViewRegister implements DataviewRegister {

    @Override
    public String code() {
        return "kms_grab_rule_data_view";
    }

    @Override
    public String desc() {
        return "KMS单据抓取规则数据视图";
    }

    @Override
    public String buildSql() {
        return  "SELECT kgr.*,kdks.supermarket_name,kdks.business_format_code,kdks.business_unit_code,kdks.sales_org_code " +
                "FROM kms_grab_rule kgr " +
                "LEFT JOIN " +
                "(SELECT kd.direct_code,ks.supermarket_name,kd.business_format_code,kd.business_unit_code,kd.sales_org_code " +
                "FROM kms_direct kd " +
                "LEFT JOIN kms_supermarket ks ON kd.supermarket_code = ks.supermarket_code " +
                "AND ks.del_flag = '"+ DelFlagStatusEnum.NORMAL.getCode() + "' " +
                "where kd.del_flag = '"+ DelFlagStatusEnum.NORMAL.getCode() + "' " +
                ") kdks " +
                "ON kgr.direct_code = kdks.direct_code " +
                "WHERE kgr.tenant_code = :tenantCode " +
                "And kgr.direct_code = :directCode " +
                "AND kgr.del_flag = '"+ DelFlagStatusEnum.NORMAL.getCode() + "' ";
    }
}

