package com.biz.crm.kms.admin.web.dataview;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import org.springframework.stereotype.Component;

/**
 * 验收单原始数据表数据视图注册器
 *
 * @author pengxi
 * @date 2022/10/17
 */
@Component
public class InvoiceAcceptanceGrabDataViewRegister implements DataviewRegister {

  @Override
  public String code() {
    return "kms_invoice_acceptance_grab_data_view";
  }

  @Override
  public String desc() {
    return "KMS验收单原始数据数据视图";
  }

  @Override
  public String buildSql() {
    return "SELECT iag.* FROM kms_invoice_acceptance_grab iag " +
    "WHERE iag.tenant_code = :tenantCode " +
    "AND iag.del_flag = '" + DelFlagStatusEnum.NORMAL.getCode() + "' ";
  }
}
