package com.biz.crm.kms.admin.web.dataview;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import org.springframework.stereotype.Component;

/**
 * KMS订货单(转换后）数据视图注册器
 *
 * @author 郑波
 * @date 2022/10/31
 */
@Component
public class OrderDataViewRegister implements DataviewRegister {

  @Override
  public String code() {
    return "kms_order_data_view";
  }

  @Override
  public String desc() {
    return "KMS订货单（转换后）数据视图";
  }

  @Override
  public String buildSql() {
    return "SELECT ko.* FROM kms_order ko " +
           "WHERE ko.tenant_code = :tenantCode " +
           "AND ko.del_flag = '" + DelFlagStatusEnum.NORMAL.getCode() + "' ";
  }
}
