package com.biz.crm.kms.admin.web.dataview;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalSearchDto;
import com.biz.crm.mdm.business.terminal.sdk.service.TerminalVoService;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalVo;
import com.bizunited.nebula.europa.database.sdk.strategy.ExternalQueryInterceptor;
import com.bizunited.nebula.europa.sdk.context.execute.ExecuteContent;
import com.bizunited.nebula.europa.sdk.context.matedata.MetaData;
import com.bizunited.nebula.europa.sdk.vo.EuropaInfoVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import javax.persistence.EntityManager;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 费用上账数据视图补充
 *
 * @author ning.zhang
 * @date 2022/10/20
 */
@Component
public class OrderQueryInterceptor implements ExternalQueryInterceptor {

  private static final String STORE_CODE = "store_code";

  private static final String FINAL_ORDER_AMOUNT = "final_order_amount";

  private static final String FINAL_ORDER_AMOUNT_NOT = "final_order_amount_not";

  @Autowired
  private TerminalVoService terminalVoService;

  @Override
  public String code() {
    return "kms_order_query_interceptor";
  }

  @Override
  public String name() {
    return "kms订货单-参数补充";
  }

  @Override
  public List<Object[]> process(EntityManager entityManager, MetaData metaData, EuropaInfoVo europaInfoVo
      , ExecuteContent executeContent, String... strings) {
    List<Map<String, Object>> results = executeContent.getResults();
    if (CollectionUtils.isEmpty(results)) {
      return Lists.newLinkedList();
    }
    List<Object[]> externalContents = Lists.newArrayList();
    Set<String> terminalCodes = results.stream().filter(resultMap -> Objects.nonNull(resultMap.get(STORE_CODE)))
        .map(resultMap -> String.valueOf(resultMap.get(STORE_CODE)))
        .collect(Collectors.toSet());
    Map<String, TerminalVo> terminalMap = Maps.newHashMap();
    if (!CollectionUtils.isEmpty(terminalCodes)) {
      TerminalSearchDto searchDto = new TerminalSearchDto();
      searchDto.setTerminalCodeSet(terminalCodes);
      searchDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
      List<TerminalVo> terminalList = this.terminalVoService.findByTerminalSearchDto(searchDto);
      terminalMap = terminalList.stream().collect(Collectors.toMap(TerminalVo::getTerminalCode, t -> t, (a, b) -> a));
    }

    for (Map<String, Object> result : results) {
      List<Object> itemList = Lists.newArrayList();
      String terminalCode = (String) result.get(STORE_CODE);
      BigDecimal finalOrderAmount = (BigDecimal) ObjectUtils.defaultIfNull(result.get(FINAL_ORDER_AMOUNT), BigDecimal.ZERO);
      BigDecimal finalOrderAmountNot = (BigDecimal) ObjectUtils.defaultIfNull(result.get(FINAL_ORDER_AMOUNT_NOT), BigDecimal.ZERO);
      TerminalVo terminalVo = terminalMap.getOrDefault(terminalCode, new TerminalVo());
      for (String externalFieldName : strings) {
        if (StringUtils.equals(externalFieldName, "terminal_type")) {
//          itemList.add(terminalVo.getTerminalType());
        }
        if (StringUtils.equals(externalFieldName, "tax_situation")) {
          itemList.add(finalOrderAmount.compareTo(finalOrderAmountNot) > 0 ? "含税" : "不含税");
        }
      }
      externalContents.add(itemList.toArray(new Object[]{}));
    }
    return externalContents;
  }
}
