package com.biz.crm.kms.admin.web.dataview;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import org.springframework.stereotype.Component;

/**
 * KMS销售（转换后）数据视图
 *
 * @author ning.zhang
 * @date 2022/11/8
 */
@Component
public class SalesDataViewRegister implements DataviewRegister {

  @Override
  public String code() {
    return "kms_sales_data_view";
  }

  @Override
  public String desc() {
    return "KMS销售（转换后）数据视图";
  }

  @Override
  public String buildSql() {
    return "SELECT ko.*," +
            "DATE_FORMAT( ko.create_time, '%Y-%m-%d %T' ) AS 'create_time_export'," +
            "DATE_FORMAT( ko.modify_time, '%Y-%m-%d %T' ) AS 'modify_time_export'," +
            "kd.sales_org_code " +
            "FROM kms_sales_data ko " +
            "LEFT JOIN kms_direct kd on ko.direct_code = kd.direct_code " +
            "AND kd.del_flag = '"+ DelFlagStatusEnum.NORMAL.getCode() + "' " +
            "WHERE ko.tenant_code = :tenantCode " +
            "AND ko.del_flag = '" + DelFlagStatusEnum.NORMAL.getCode() + "' ";
  }
}
