package com.biz.crm.kms.admin.web.dataview;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import org.springframework.stereotype.Component;

/**
 * 商场管理列表数据视图注册器
 *
 * @author songjingen
 * @date 2022/9/22
 */
@Component
public class SupermarketDataViewRegister implements DataviewRegister {

  @Override
  public String code() {
    return "kms_supermarket_data_view";
  }

  @Override
  public String desc() {
    return "KMS商超管理数据视图";
  }

  @Override
  public String buildSql() {
    return "select distinct ks.*,group_concat(ksa.area_name) as areaNames from kms_supermarket ks " +
        "left join kms_supermarket_area ksa on ks.supermarket_code = ksa.supermarket_code " +
        "where ks.tenant_code = :tenantCode " +
        "and ks.del_flag = '" + DelFlagStatusEnum.NORMAL.getCode() + "' " +
        "group by ks.id ";
  }
}
