package com.biz.crm.kms.admin.web.dataview;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import org.springframework.stereotype.Component;

/**
 * 商超抓单参数数据视图注册器
 *
 * @author zhengbo
 * @date 2022/9/26
 */
@Component
public class SupermarketInterfaceDataViewRegister implements DataviewRegister {

  @Override
  public String code() {
    return "kms_supermarket_parameter_data_view";
  }

  @Override
  public String desc() {
    return "KMS商超抓单参数数据视图";
  }

  @Override
  public String buildSql() {
    return "SELECT ksp.* FROM kms_supermarket_parameter ksp " +
    "WHERE ksp.tenant_code = :tenantCode " +
    "And ksp.supermarket_code = :supermarketCode " +
    "AND ksp.del_flag = '" + DelFlagStatusEnum.NORMAL.getCode() + "' ";
  }
}
