package com.biz.crm.kms.admin.web.dataview;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import org.springframework.stereotype.Component;

/**
 * KMS商场门店数据视图注册器
 *
 * @author zhengbo
 * @date 2022/9/22
 */
@Component
public class SupermarketStoreDataViewRegister implements DataviewRegister {

  @Override
  public String code() {
    return "kms_supermarket_store_data_view";
  }

  @Override
  public String desc() {
    return "KMS商超门店数据视图";
  }

  @Override
  public String buildSql() {
    return "select kss.*,ksa.area_name as areaNames FROM kms_supermarket_store kss " +
    "LEFT JOIN kms_supermarket_area ksa ON kss.supermarket_area_code = ksa.area_code " +
    "AND kss.supermarket_code = ksa.supermarket_code " +
    "WHERE kss.tenant_code = :tenantCode " +
    "And kss.supermarket_code = :supermarketCode " +
    "AND kss.del_flag = '"+ DelFlagStatusEnum.NORMAL.getCode() + "' ";
  }
}
