package com.biz.crm.kms.admin.web.dataview.parambind;


import com.bizunited.nebula.europa.database.sdk.context.execute.DatabaseExecuteExternalRequest;
import com.bizunited.nebula.europa.database.sdk.strategy.ParameterValueBindingStrategy;
import com.bizunited.nebula.europa.sdk.context.execute.ExecuteParameter;
import org.springframework.stereotype.Component;

/**
 * 商超列表树专用-商超左侧编号（supermarketCode）
 * @author 波波
 */
@Component
public class SupermarketCodeParamFieldBindingStrategy implements ParameterValueBindingStrategy {

    private static final String PARAM_BIND_TYPE = "supermarketCode";

    @Override
    public String getBindType() {
        return this.PARAM_BIND_TYPE;
    }

    @Override
    public String getBindTypeCnName() {
        return "商超列表树专用-商超左侧编号（supermarketCode）";
    }

    @Override
    public Boolean getOutside() {
        return false;
    }

    @Override
    public Class<?>[] matchedJavaClasses() {
        return new Class[]{CharSequence.class};
    }

    @Override
    public Object bindingFieldValue(ExecuteParameter executeParameter, DatabaseExecuteExternalRequest invokeParamContent) {
        return invokeParamContent.getAttribute(this.PARAM_BIND_TYPE);
    }
}
