package com.biz.crm.kms.admin.web.exports.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 直营上架产品导出dto
 *
 * @author xi.peng
 * @since 2022-09-23 10:45:22
 */
@Data
@ApiModel(value = "DirectProductExportDto", description = "直营上架产品管理表Dto")
public class DirectProductExportDto extends TenantFlagOpDto {

  /**
   * 系统编码
   */
  @ApiModelProperty("*系统编码(例:CR-0001)")
  private String directCode;

  /**
   * 售达方编码
   */
  @ApiModelProperty("*售达方编码(例:300002029)")
  private String sellPartyCode;

  /**
   * 售达方名称
   */
  @ApiModelProperty("*售达方名称")
  private String sellPartyName;

  /**
   * 企业产品编码
   */
  @ApiModelProperty("*企业产品编码(例:50004439)")
  private String productCode;

  /**
   * 送达方编码
   */
  @ApiModelProperty("送达方编码")
  private String deliveryPartyCode;

  /**
   * 送达方编码
   */
  @ApiModelProperty("送达方名称")
  private String deliveryPartyName;
  /**
   * 企业产品编码
   */
  @ApiModelProperty("*企业产品编码")
  private String productName;

  /**
   * 零售商产品编码
   */
  @ApiModelProperty("*零售商产品编码(例:1032631)")
  private String kaProductCode;
  /**
   * 零售商产品编码
   */
  @ApiModelProperty("*零售商产品名称")
  private String kaProductName;

  /**
   * 是否默认物料（0：否，1：是）
   */
  @ApiModelProperty("*是否默认产品(例:1)")
  private String isDefault;

  /**
   * 上下架（0：下架，1：上架）
   */
  @ApiModelProperty("*是否上架产品(例:1)")
  private String onShelfStatus;

  /**
   * 单据类型
   */
  @ApiModelProperty("*单据类型 (例:验收单)")
  private String orderType;

  /**
   * 企业产品单位编码
   */
  @ApiModelProperty("*企业产品单位编码 (例:EA)")
  private String unitCode;

  /**
   * 企业产品单位名称
   */
  @ApiModelProperty("*企业产品单位名称 (例:EA)")
  private String unitName;

  /**
   * 企业单位数量
   */
  @ApiModelProperty("*企业单位数量 (例:1)")
  private Integer unitQuantity;

  /**
   * 商超产品单位编码
   */
  @ApiModelProperty("*商超产品单位编码 (例:XX)")
  private String kaUnitCode;

  /**
   * 商超单位数量
   */
  @ApiModelProperty("*商超单位数量 (例:1)")
  private Integer kaUnitQuantity;

}

