package com.biz.crm.kms.admin.web.exports.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 直营门店导出Vo
 *
 * @author ning.zhang
 * @date 2022/10/9
 */
@Data
@ApiModel(value = "DirectStoreExportDto", description = "直营门店导出Vo")
public class DirectStoreExportDto extends TenantFlagOpDto {


  /**
   * 系统编码
   */
  @ApiModelProperty("系统编码")
  private String directCode;

  /**
   * 企业门店编码
   */
  @ApiModelProperty("企业门店编码")
  private String terminalCode;

  /**
   * 企业门店名称
   */
  @ApiModelProperty("企业门店名称")
  private String terminalName;

  /**
   * 客户门店编码
   */
  @ApiModelProperty("客户门店编码")
  private String supermarketStoreCode;

  /**
   * 客户门店名称
   */
  @ApiModelProperty("客户门店名称")
  private String supermarketStoreName;
}
