package com.biz.crm.kms.admin.web.exports.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 退货单导出Vo
 *
 * @author ning.zhang
 * @date 2022/11/7
 */
@Data
@ApiModel(value = "ReturnOrderExportDto", description = "退货单导出Vo")
public class ReturnOrderExportDto extends TenantFlagOpDto {

  /**
   * KMS退货编号
   */
  @ApiModelProperty("KMS退货编号")
  private String orderNumber;

  /**
   * 商超退货号
   */
  @ApiModelProperty("商超退货号")
  private String kaOrderNumber;

  /**
   * 关联客户订单
   */
  @ApiModelProperty("关联客户订单")
  private String relateCustomOrder;
}
