package com.biz.crm.kms.admin.web.exports.mapper;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.kms.admin.web.exports.dto.DirectExportDto;
import com.biz.crm.kms.admin.web.exports.dto.DirectStoreExportDto;
import com.biz.crm.kms.admin.web.exports.vo.DirectExportVo;
import com.biz.crm.kms.admin.web.exports.vo.DirectStoreExportVo;
import org.apache.ibatis.annotations.Param;

/**
 * 直营门店导出数据Mapper
 *
 * @author ning.zhang
 * @date 2022/10/9
 */
public interface DirectStoreExportMapper {

  /**
   * 直营门店分页列表
   *
   * @param dto  请求参数dto
   * @param page 分页信息
   * @return Page<DirectStoreExportVo> 直营门店分页信息
   */
  Page<DirectStoreExportVo> findByConditions(Page<DirectStoreExportVo> page, @Param("dto") DirectStoreExportDto dto);
}
