package com.biz.crm.kms.admin.web.exports.mapper;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.kms.admin.web.exports.dto.OrderExportDto;
import com.biz.crm.kms.admin.web.exports.vo.OrderExportVo;
import org.apache.ibatis.annotations.Param;

/**
 * 订货单导出数据Mapper
 *
 * @author ning.zhang
 * @date 2022/11/7
 */
public interface OrderExportMapper {

  /**
   * 订货单分页列表
   *
   * @param dto  请求参数dto
   * @param page 分页信息
   * @return Page<OrderExportVo> 订货单分页信息
   */
  Page<OrderExportVo> findByConditions(Page<OrderExportVo> page, @Param("dto") OrderExportDto dto);
}
