package com.biz.crm.kms.admin.web.exports.mapper;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.kms.admin.web.exports.dto.SupermarketStoreExportDto;
import com.biz.crm.kms.admin.web.exports.vo.SupermarketStoreExportVo;
import org.apache.ibatis.annotations.Param;

/**
 *  商超门店导出数据Mapper
 *
 * @author ning.zhang
 * @date 2022/9/23
 */
public interface SupermarketStoreExportMapper {

  /**
   * 商超门店分页列表
   *
   * @param dto  请求参数dto
   * @param page 分页信息
   * @return Page<SupermarketStoreExportVo> 商超门店分页信息
   */
  Page<SupermarketStoreExportVo> findByConditions(Page<SupermarketStoreExportVo> page, @Param("dto") SupermarketStoreExportDto dto);
}
