package com.biz.crm.kms.admin.web.exports.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.kms.admin.web.constant.DictCodeConstant;
import com.biz.crm.kms.admin.web.exports.dto.DirectExportDto;
import com.biz.crm.kms.admin.web.exports.mapper.DirectExportMapper;
import com.biz.crm.kms.admin.web.exports.vo.DirectExportVo;
import com.biz.crm.kms.admin.web.utils.DictValueUtil;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @author songjingen
 * @date 2022/9/28
 */
@Component
public class DirectExportProcess implements ExportProcess<DirectExportVo> {

  @Autowired
  private DirectExportMapper directExportMapper;

  @Autowired(required = false)
  private DictDataVoService dictDataVoService;

  @Override
  public Integer getTotal(Map<String, Object> params) {
    DirectExportDto dto = this.convertParams(params);
    Page<DirectExportVo> pageResult = this.directExportMapper.findByConditions(new Page<>(0, 1), dto);
    return ((int) (pageResult.getTotal()));
  }

  @Override
  public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
    DirectExportDto dto = this.convertParams(params);
    Page<DirectExportVo> pageable = new Page<>(vo.getPageNo(), this.getPageSize());
    Page<DirectExportVo> page = this.directExportMapper.findByConditions(pageable, dto);
    return JSON.parseArray(JSON.toJSONString(adjustData(page.getRecords())));
  }

  @Override
  public Class<DirectExportVo> findCrmExcelVoClass() {
    return DirectExportVo.class;
  }

  @Override
  public String getBusinessCode() {
    return "KMS_DIRECT_EXPORT";
  }

  @Override
  public String getBusinessName() {
    return "系统导出";
  }

  /**
   * 转换参数
   *
   * @param params 传递参数
   * @return 转换结果
   */
  private DirectExportDto convertParams(Map<String, Object> params) {
    // map 参数转换为对应的dto参数对象，可以手工进行修改设置
    DirectExportDto dto = JSON.parseObject(JSON.toJSONString(params), DirectExportDto.class);
    dto.setTenantCode(TenantUtils.getTenantCode());
    return dto;
  }

  /**
   * 调整数据
   *
   * @param data 待调整数据
   * @return 调整后数据
   */
  private List<DirectExportVo> adjustData(List<DirectExportVo> data) {
    if (CollectionUtils.isEmpty(data)) {
      return new ArrayList<>(0);
    }
    Map<String, List<DictDataVo>> mapDict = this.dictDataVoService.findByDictTypeCodeList(Lists.newArrayList(DictCodeConstant.DICT_ENABLE));
    for (DirectExportVo datum : data) {
      datum.setEnableStatus(DictValueUtil.findDictValue(mapDict, DictCodeConstant.DICT_ENABLE, datum.getEnableStatus()));
    }
    return data;
  }
}
