package com.biz.crm.kms.admin.web.exports.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.kms.admin.web.exports.dto.DirectProductExportDto;
import com.biz.crm.kms.admin.web.exports.mapper.DirectProductExportMapper;
import com.biz.crm.kms.admin.web.exports.vo.DirectProductExportVo;
import com.biz.crm.kms.business.invoice.statement.local.exports.vo.InvoiceStatementExportVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 直营上架产品导出
 *
 * @author pengxi
 * @date 2022/10/9
 */
@Component
public class DirectProductExportProcess implements ExportProcess<DirectProductExportVo> {

  @Autowired(required = false) private DirectProductExportMapper directProductExportMapper;

  @Autowired(required = false)
  private DictDataVoService dictDataVoService;

  @Override
  public Integer getTotal(Map<String, Object> params) {
    DirectProductExportDto dto = this.convertParams(params);
    Page<DirectProductExportVo> pageResult = this.directProductExportMapper.findByConditions(new Page<>(0, 1), dto);
    return ((int) (pageResult.getTotal()));
  }

  @Override
  public JSONArray getData(ExportTaskProcessVo processVo, Map<String, Object> params) {
    //分页问题修改
    if(processVo.getPageNo() == null || processVo.getPageSize() ==null){
      throw new IllegalArgumentException("参数错误");
    }
    processVo.setPageNo(processVo.getPageNo()+1);
    DirectProductExportDto dto = this.convertParams(params);
    Page<DirectProductExportDto> pageable = new Page<>(processVo.getPageNo(), this.getPageSize());
    Page<DirectProductExportVo> page = this.directProductExportMapper.findByConditions(pageable, dto);
    this.buildVo(page.getRecords());
    return JSON.parseArray(JSON.toJSONString((page.getRecords())));
  }

  @Override
  public Class<DirectProductExportVo> findCrmExcelVoClass() {
    return DirectProductExportVo.class;
  }

  @Override
  public String getBusinessCode() {
    return "KMS_DIRECT_PRODUCT_EXPORT";
  }

  @Override
  public String getBusinessName() {
    return "KMS上架产品导出";
  }

  /**
   * 转换参数
   *
   * @param params 传递参数
   * @return 转换结果
   */
  private DirectProductExportDto convertParams(Map<String, Object> params) {
// map 参数转换为对应的dto参数对象，可以手工进行修改设置
    params.remove("sort");
    params.remove("europaInfoCode");
    params.remove("bsDirectSystemId");
    params.remove("code");
    String directCode = null;
    if (Objects.nonNull(params.get("directCode"))){
      directCode = params.get("directCode").toString();
    }
    params.remove("directCode");
    Map<String, Object> map = params.entrySet().stream()
            .collect(Collectors.toMap(e -> e.getKey().substring(0, e.getKey().lastIndexOf("_")), Map.Entry::getValue,(a, b)->a));
    // map 参数转换为对应的dto参数对象，可以手工进行修改设置
    DirectProductExportDto dto = JSON.parseObject(JSON.toJSONString(map), DirectProductExportDto.class);
    if (StringUtils.isNotEmpty(directCode)){
      dto.setDirectCode(directCode);
    }
    dto.setTenantCode(TenantUtils.getTenantCode());
    dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
    return dto;
  }

  private void buildVo(List<DirectProductExportVo> page){
    if (org.springframework.util.CollectionUtils.isEmpty(page)){
      return;
    }
    Map<String, String> businessFormatMap = new HashMap<>();
    Map<String, String> businessUnitMap = new HashMap<>();
    List<DictDataVo> businessFormat = dictDataVoService.findByDictTypeCode("mdm_business_format");
    List<DictDataVo> businessUnit = dictDataVoService.findByDictTypeCode("mdm_business_unit");
    if (CollectionUtils.isNotEmpty(businessFormat)){
      businessFormatMap = businessFormat.stream().collect(Collectors.toMap(DictDataVo::getDictCode, DictDataVo::getDictValue, (a, b) -> a));
    }
    if (CollectionUtils.isNotEmpty(businessUnit)){
      businessUnitMap = businessUnit.stream().collect(Collectors.toMap(DictDataVo::getDictCode, DictDataVo::getDictValue, (a, b) -> a));
    }
    for (DirectProductExportVo directProductExportVo : page) {
      directProductExportVo.setBusinessUnitCode(businessUnitMap.get(directProductExportVo.getBusinessUnitCode()));
      directProductExportVo.setBusinessFormatCode(businessFormatMap.get(directProductExportVo.getBusinessFormatCode()));
    }
  }
}
