package com.biz.crm.kms.admin.web.exports.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.kms.admin.web.exports.dto.DirectStoreExportDto;
import com.biz.crm.kms.admin.web.exports.mapper.DirectStoreExportMapper;
import com.biz.crm.kms.admin.web.exports.vo.DirectStoreExportVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * 直营门店信息导出
 *
 * @author ning.zhang
 * @date 2022/10/9
 */
@Component
public class DirectStoreExportProcess implements ExportProcess<DirectStoreExportVo> {

  @Autowired
  private DirectStoreExportMapper directStoreExportMapper;

  @Override
  public Integer getTotal(Map<String, Object> params) {
    DirectStoreExportDto dto = this.convertParams(params);
    Page<DirectStoreExportVo> pageResult = this.directStoreExportMapper.findByConditions(new Page<>(0, 1), dto);
    return ((int) (pageResult.getTotal()));
  }

  @Override
  public JSONArray getData(ExportTaskProcessVo processVo, Map<String, Object> params) {
    DirectStoreExportDto dto = this.convertParams(params);
    Page<DirectStoreExportVo> pageable = new Page<>(processVo.getPageNo(), this.getPageSize());
    Page<DirectStoreExportVo> page = this.directStoreExportMapper.findByConditions(pageable, dto);
    return JSON.parseArray(JSON.toJSONString(page.getRecords()));
  }

  @Override
  public Class<DirectStoreExportVo> findCrmExcelVoClass() {
    return DirectStoreExportVo.class;
  }

  @Override
  public String getBusinessCode() {
    return "KMS_DIRECT_STORE_EXPORT";
  }

  @Override
  public String getBusinessName() {
    return "KMS直营门店导出";
  }

  /**
   * 转换参数
   *
   * @param params 传递参数
   * @return 转换结果
   */
  private DirectStoreExportDto convertParams(Map<String, Object> params) {
    // map 参数转换为对应的dto参数对象，可以手工进行修改设置
    DirectStoreExportDto dto = JSON.parseObject(JSON.toJSONString(params), DirectStoreExportDto.class);
    dto.setTenantCode(TenantUtils.getTenantCode());
    dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
    dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
    return dto;
  }
}
