package com.biz.crm.kms.admin.web.exports.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.kms.admin.web.exports.dto.OrderExportDto;
import com.biz.crm.kms.admin.web.exports.mapper.OrderExportMapper;
import com.biz.crm.kms.admin.web.exports.vo.OrderExportVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * 订货单信息导出
 *
 * @author ning.zhang
 * @date 2022/11/7
 */
@Component
public class OrderExportProcess implements ExportProcess<OrderExportVo> {

  @Autowired
  private OrderExportMapper orderExportMapper;

  @Override
  public Integer getTotal(Map<String, Object> params) {
    OrderExportDto dto = this.convertParams(params);
    Page<OrderExportVo> pageResult = this.orderExportMapper.findByConditions(new Page<>(0, 1), dto);
    return ((int) (pageResult.getTotal()));
  }

  @Override
  public JSONArray getData(ExportTaskProcessVo processVo, Map<String, Object> params) {
    OrderExportDto dto = this.convertParams(params);
    Page<OrderExportVo> pageable = new Page<>(processVo.getPageNo(), processVo.getPageSize());
    Page<OrderExportVo> page = this.orderExportMapper.findByConditions(pageable, dto);
    return JSON.parseArray(JSON.toJSONString(page.getRecords()));
  }

  @Override
  public Class<OrderExportVo> findCrmExcelVoClass() {
    return OrderExportVo.class;
  }

  @Override
  public String getBusinessCode() {
    return "KMS_ORDER_EXPORT";
  }

  @Override
  public String getBusinessName() {
    return "订货单导出";
  }

  /**
   * 转换参数
   *
   * @param params 传递参数
   * @return 转换结果
   */
  private OrderExportDto convertParams(Map<String, Object> params) {
    // map 参数转换为对应的dto参数对象，可以手工进行修改设置
    OrderExportDto dto = JSON.parseObject(JSON.toJSONString(params), OrderExportDto.class);
    dto.setTenantCode(TenantUtils.getTenantCode());
    dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
    dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
    return dto;
  }
}
