package com.biz.crm.kms.admin.web.exports.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.kms.admin.web.exports.dto.ReturnOrderExportDto;
import com.biz.crm.kms.admin.web.exports.mapper.ReturnOrderExportMapper;
import com.biz.crm.kms.admin.web.exports.vo.ReturnOrderExportVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * 退货单信息导出
 *
 * @author ning.zhang
 * @date 2022/11/7
 */
@Component
public class ReturnOrderExportProcess implements ExportProcess<ReturnOrderExportVo> {

  @Autowired
  private ReturnOrderExportMapper returnOrderExportMapper;

  @Override
  public Integer getTotal(Map<String, Object> params) {
    ReturnOrderExportDto dto = this.convertParams(params);
    Page<ReturnOrderExportVo> pageResult = this.returnOrderExportMapper.findByConditions(new Page<>(0, 1), dto);
    return ((int) (pageResult.getTotal()));
  }

  @Override
  public JSONArray getData(ExportTaskProcessVo processVo, Map<String, Object> params) {
    ReturnOrderExportDto dto = this.convertParams(params);
    Page<ReturnOrderExportVo> pageable = new Page<>(processVo.getPageNo(), this.getPageSize());
    Page<ReturnOrderExportVo> page = this.returnOrderExportMapper.findByConditions(pageable, dto);
    return JSON.parseArray(JSON.toJSONString(page.getRecords()));
  }

  @Override
  public Class<ReturnOrderExportVo> findCrmExcelVoClass() {
    return ReturnOrderExportVo.class;
  }

  @Override
  public String getBusinessCode() {
    return "KMS_RETURN_ORDER_EXPORT";
  }

  @Override
  public String getBusinessName() {
    return "退货单导出";
  }

  /**
   * 转换参数
   *
   * @param params 传递参数
   * @return 转换结果
   */
  private ReturnOrderExportDto convertParams(Map<String, Object> params) {
    // map 参数转换为对应的dto参数对象，可以手工进行修改设置
    ReturnOrderExportDto dto = JSON.parseObject(JSON.toJSONString(params), ReturnOrderExportDto.class);
    dto.setTenantCode(TenantUtils.getTenantCode());
    dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
    dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
    return dto;
  }
}
