package com.biz.crm.kms.admin.web.exports.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.kms.admin.web.exports.dto.SalesDataExportDto;
import com.biz.crm.kms.admin.web.exports.mapper.SalesDataExportMapper;
import com.biz.crm.kms.admin.web.exports.vo.SalesDataExportVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * 销售数据导出
 *
 * @author ning.zhang
 * @date 2022/11/11
 */
@Component
public class SalesDataExportProcess implements ExportProcess<SalesDataExportVo> {

  @Autowired
  private SalesDataExportMapper salesDataExportMapper;

  @Override
  public Integer getTotal(Map<String, Object> params) {
    SalesDataExportDto dto = this.convertParams(params);
    Page<SalesDataExportVo> pageResult = this.salesDataExportMapper.findByConditions(new Page<>(0, 1), dto);
    return ((int) (pageResult.getTotal()));
  }

  @Override
  public JSONArray getData(ExportTaskProcessVo processVo, Map<String, Object> params) {
    SalesDataExportDto dto = this.convertParams(params);
    Page<SalesDataExportVo> pageable = new Page<>(processVo.getPageNo(), this.getPageSize());
    Page<SalesDataExportVo> page = this.salesDataExportMapper.findByConditions(pageable, dto);
    return JSON.parseArray(JSON.toJSONString(page.getRecords()));
  }

  @Override
  public Class<SalesDataExportVo> findCrmExcelVoClass() {
    return SalesDataExportVo.class;
  }

  @Override
  public String getBusinessCode() {
    return "KMS_SALES_DATA_EXPORT";
  }

  @Override
  public String getBusinessName() {
    return "销售数据导出";
  }

  /**
   * 转换参数
   *
   * @param params 传递参数
   * @return 转换结果
   */
  private SalesDataExportDto convertParams(Map<String, Object> params) {
    // map 参数转换为对应的dto参数对象，可以手工进行修改设置
    SalesDataExportDto dto = JSON.parseObject(JSON.toJSONString(params), SalesDataExportDto.class);
    dto.setTenantCode(TenantUtils.getTenantCode());
    dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
    dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
    return dto;
  }
}
