package com.biz.crm.kms.admin.web.exports.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.kms.admin.web.exports.dto.SupermarketStoreExportDto;
import com.biz.crm.kms.admin.web.exports.mapper.SupermarketStoreExportMapper;
import com.biz.crm.kms.admin.web.exports.vo.SupermarketStoreExportVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 商超门店信息导出
 *
 * @author ning.zhang
 * @date 2022/9/23
 */
@Component
public class SupermarketStoreExportProcess implements ExportProcess<SupermarketStoreExportVo> {

  @Autowired
  private SupermarketStoreExportMapper supermarketStoreExportMapper;

  @Override
  public Integer getTotal(Map<String, Object> params) {
    SupermarketStoreExportDto dto = this.convertParams(params);
    Page<SupermarketStoreExportVo> pageResult = this.supermarketStoreExportMapper.findByConditions(new Page<>(0, 1), dto);
    return ((int) (pageResult.getTotal()));
  }

  @Override
  public JSONArray getData(ExportTaskProcessVo processVo, Map<String, Object> params) {
    SupermarketStoreExportDto dto = this.convertParams(params);
    Page<SupermarketStoreExportVo> pageable = new Page<>(processVo.getPageNo(), this.getPageSize());
    Page<SupermarketStoreExportVo> page = this.supermarketStoreExportMapper.findByConditions(pageable, dto);
    return JSON.parseArray(JSON.toJSONString(adjustData(page.getRecords())));
  }

  @Override
  public Class<SupermarketStoreExportVo> findCrmExcelVoClass() {
    return SupermarketStoreExportVo.class;
  }

  @Override
  public String getBusinessCode() {
    return "KMS_SUPERMARKET_STORE_EXPORT";
  }

  @Override
  public String getBusinessName() {
    return "KMS商超门店导出";
  }

  /**
   * 转换参数
   *
   * @param params 传递参数
   * @return 转换结果
   */
  private SupermarketStoreExportDto convertParams(Map<String, Object> params) {
    // map 参数转换为对应的dto参数对象，可以手工进行修改设置
    SupermarketStoreExportDto dto = JSON.parseObject(JSON.toJSONString(params), SupermarketStoreExportDto.class);
    dto.setTenantCode(TenantUtils.getTenantCode());
    dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
    dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
    return dto;
  }

  /**
   * 调整数据
   *
   * @param data 待调整数据
   * @return 调整后数据
   */
  private List<SupermarketStoreExportVo> adjustData(List<SupermarketStoreExportVo> data) {
    if (CollectionUtils.isEmpty(data)) {
      return new ArrayList<>(0);
    }
    for (SupermarketStoreExportVo datum : data) {
      datum.setStoreAreaName(String.format("%s%s", datum.getSupermarketAreaName(), datum.getSupermarketName()));
    }
    return data;
  }
}
