package com.biz.crm.kms.admin.web.exports.vo;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelExport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 直营上架产品导出vo
 *
 * @author pengxi
 * @date 2022/10/9
 */
@Data
@ApiModel(value = "DirectProductExportVo", description = "直营上架产品管理表Vo")
@CrmExcelExport
public class DirectProductExportVo extends CrmExcelVo {

  /**
   * 业态
   */
  @CrmExcelColumn("*业态")
  private String businessFormatCode;

  /**
   * 业务单元
   */
  @CrmExcelColumn("*业务单元")
  private String businessUnitCode;


  /**
   * 系统编码
   */
  @CrmExcelColumn("*系统编码")
  private String directCode;

  /**
   * 售达方编码
   */
  @CrmExcelColumn("*售达方编码")
  private String sellPartyCode;
  /**
   * 售达方编码
   */
  @CrmExcelColumn("*售达方名称")
  private String sellPartyName;

  @CrmExcelColumn("*送达方编码")
  private String deliveryPartyCode;

  @CrmExcelColumn("*送达方名称")
  private String deliveryPartyName;


  /**
   * 企业产品编码
   */
  @CrmExcelColumn("*企业产品编码")
  private String productCode;
  /**
   * 企业产品名称
   */
  @CrmExcelColumn("*企业产品编码")
  private String productName;

  /**
   * 零售商产品编码
   */
  @CrmExcelColumn("*零售商产品编码")
  private String kaProductCode;
  /**
   * 零售商产品编码
   */
  @CrmExcelColumn("*零售商产品名称")
  private String kaProductName;

  /**
   * 是否默认物料（0：否，1：是）
   */
  @CrmExcelColumn("*是否默认产品(例:1)")
  private String isDefault;

  /**
   * 上下架（0：下架，1：上架）
   */
  @CrmExcelColumn("*是否上架产品(例:1)")
  private String onShelfStatus;

  /**
   * 单据类型
   */
  @CrmExcelColumn("*单据类型 (例:验收单)")
  private String orderType;

  /**
   * 企业产品单位编码
   */
  @CrmExcelColumn("*企业产品单位编码 (例:EA)")
  private String unitCode;

  /**
   * 企业产品单位名称
   */
  @CrmExcelColumn("*企业产品单位名称 (例:EA)")
  private String unitName;

  /**
   * 企业单位数量
   */
  @CrmExcelColumn("*企业单位数量 (例:1)")
  private Integer unitQuantity;

  /**
   * 商超产品单位编码
   */
  @CrmExcelColumn("*商超产品单位编码 (例:XX)")
  private String kaUnitCode;

  /**
   * 商超单位数量
   */
  @CrmExcelColumn("*商超单位数量 (例:1)")
  private Integer kaUnitQuantity;

}

