package com.biz.crm.kms.admin.web.exports.vo;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelExport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 订货单导出Vo
 *
 * @author ning.zhang
 * @date 2022/11/7
 */
@Data
@CrmExcelExport
public class OrderExportVo extends CrmExcelVo {

  /**
   * KMS订单号
   */
  @CrmExcelColumn("KMS订单号")
  private String orderNumber;

  /**
   * 商超客户编码
   */
  @CrmExcelColumn("商超客户编码")
  private String kaCode;

  /**
   * 商超客户名称
   */
  @CrmExcelColumn("商超客户名称")
  private String kaName;

  /**
   * 商超订单编号
   */
  @CrmExcelColumn("商超订单编号")
  private String kaOrderNumber;

  /**
   * 订单当前状态
   */
  @CrmExcelColumn("订单当前状态")
  private String orderStatus;

  /**
   * 单据当前状态信息
   */
  @CrmExcelColumn("单据当前状态信息")
  private String orderStatusMsg;

  /**
   * 企业门店编号
   */
  @CrmExcelColumn("企业门店编号")
  private String storeCode;

  /**
   * 企业门店名称
   */
  @CrmExcelColumn("企业门店名称")
  private String storeName;

  /**
   * 客户门店编号
   */
  @CrmExcelColumn("客户门店编号")
  private String kaStoreCode;

  /**
   * 客户门店名称
   */
  @CrmExcelColumn("客户门店名称")
  private String kaStoreName;

  /**
   * 订单日期
   */
  @CrmExcelColumn("订单日期")
  private String orderDate;

  /**
   * 业务区域
   */
  @CrmExcelColumn("业务区域")
  private String businessArea;

  /**
   * 交货日期
   */
  @CrmExcelColumn("交货日期")
  private String deliveryDate;

  /**
   * 含税订单总金额
   */
  @CrmExcelColumn("含税订单总金额")
  private BigDecimal finalOrderAmount;

  /**
   * 经营方式
   */
  @CrmExcelColumn("经营方式")
  private String runMode;

  /**
   * 送货联系人
   */
  @CrmExcelColumn("送货联系人")
  private String deliveryContact;

  /**
   * 送货地址
   */
  @CrmExcelColumn("送货地址")
  private String deliveryAddress;

  /**
   * 送货联系人电话
   */
  @CrmExcelColumn("送货联系人电话")
  private String deliveryContactPhone;

  /**
   * 单据来源
   */
  @CrmExcelColumn("单据来源")
  private String invoicesSource;

  /**
   * 创建人名称
   */
  @CrmExcelColumn("创建人名称")
  private String createName;

  /**
   * 创建时间
   */
  @CrmExcelColumn("创建时间")
  private String createTime;

  /**
   * 区域编码
   */
  @CrmExcelColumn("区域编码")
  private String areaCode;

  /**
   * 区域名称
   */
  @CrmExcelColumn("区域名称")
  private String areaName;

  /**
   * 业务区域负责人
   */
  @CrmExcelColumn("业务区域负责人")
  private String businessAreaLeader;

  /**
   * 订单总金额
   */
  @CrmExcelColumn("订单总金额")
  private BigDecimal finalOrderAmountNot;

  /**
   * 含税情况
   */
  @CrmExcelColumn("含税情况")
  private String taxSituation;

  /**
   * 门店类型
   */
  @CrmExcelColumn("门店类型")
  private String terminalType;

}
