package com.biz.crm.kms.admin.web.exports.vo;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelExport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 退货单导出Vo
 *
 * @author ning.zhang
 * @date 2022/11/7
 */
@Data
@CrmExcelExport
public class ReturnOrderExportVo extends CrmExcelVo {

  /**
   * 企业退货单编码
   */
  @CrmExcelColumn("企业退货单编码")
  private String orderNumber;

  /**
   * 客户退货单编码
   */
  @CrmExcelColumn("客户退货单编码")
  private String kaOrderNumber;

  /**
   * 关联客户订单
   */
  @CrmExcelColumn("关联客户订单")
  private String relateCustomOrder;

  /**
   * 客户编码
   */
  @CrmExcelColumn("客户编码")
  private String kaCode;

  /**
   * 客户名称
   */
  @CrmExcelColumn("客户名称")
  private String kaName;

  /**
   * 企业门店编号
   */
  @CrmExcelColumn("企业门店编号")
  private String storeCode;

  /**
   * 企业门店名称
   */
  @CrmExcelColumn("企业门店名称")
  private String storeName;

  /**
   * 客户门店编号
   */
  @CrmExcelColumn("客户门店编号")
  private String kaStoreCode;

  /**
   * 客户门店名称
   */
  @CrmExcelColumn("客户门店名称")
  private String kaStoreName;

  /**
   * 业务区域
   */
  @CrmExcelColumn("业务区域")
  private String businessArea;

  /**
   * 门店所属大区
   */
  @CrmExcelColumn("门店所属大区")
  private String areaName;

  /**
   * 业务区域负责人
   */
  @CrmExcelColumn("业务区域负责人")
  private String businessAreaLeader;

  /**
   * 单据日期
   */
  @CrmExcelColumn("单据日期")
  private String orderDate;

  /**
   * 登录账号
   */
  @CrmExcelColumn("登录账号")
  private String userName;

  /**
   * 货单总金额
   */
  @CrmExcelColumn("货单总金额")
  private BigDecimal returnAmount;

  /**
   * 退货原因
   */
  @CrmExcelColumn("退货原因")
  private String returnReason;

  /**
   * 单据来源
   */
  @CrmExcelColumn("单据来源")
  private String invoicesSource;

  /**
   * 创建时间
   */
  @CrmExcelColumn("创建时间")
  private String createTime;

  /**
   * 创建用户
   */
  @CrmExcelColumn("创建用户")
  private String createName;

  /**
   * 单据状态
   */
  @CrmExcelColumn("单据状态")
  private String orderStatus;

  /**
   * 状态信息
   */
  @CrmExcelColumn("状态信息")
  private String orderStatusMsg;

  /**
   * 备注信息
   */
  @CrmExcelColumn("备注信息")
  private String remark;
}
