package com.biz.crm.kms.admin.web.exports.vo;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelExport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 销售数据导出Vo
 *
 * @author ning.zhang
 * @date 2022/11/9
 */
@Data
@CrmExcelExport
public class SalesDataExportVo extends CrmExcelVo {

  /**
   * 企业销售数据编号
   */
  @CrmExcelColumn("企业销售数据编号")
  private String orderNumber;

  /**
   * 商超编码
   */
  @CrmExcelColumn("商超编码")
  private String kaCode;

  /**
   * 商超名称
   */
  @CrmExcelColumn("商超名称")
  private String kaName;

  /**
   * 单据状态
   */
  @CrmExcelColumn("单据状态")
  private String orderStatus;

  /**
   * 状态描述
   */
  @CrmExcelColumn("状态描述")
  private String orderStatusMsg;

  /**
   * 商超门店/大仓名称
   */
  @CrmExcelColumn("商超门店/大仓名称")
  private String kaStoreCode;

  /**
   * 商超门店/大仓编号
   */
  @CrmExcelColumn("商超门店/大仓编号")
  private String kaStoreName;

  /**
   * 企业门店编号
   */
  @CrmExcelColumn("企业门店编号")
  private String storeCode;

  /**
   * 企业门店名称
   */
  @CrmExcelColumn("企业门店名称")
  private String storeName;

  /**
   * 销售日期
   */
  @CrmExcelColumn("销售日期")
  private String salesDate;

  /**
   * 单据来源
   */
  @CrmExcelColumn("单据来源")
  private String invoicesSource;

  /**
   * 商超产品编号
   */
  @CrmExcelColumn("商超产品编号")
  private String kaGoodsCode;

  /**
   * 商超产品名称
   */
  @CrmExcelColumn("商超产品名称")
  private String kaGoodsName;

  /**
   * 企业产品编号
   */
  @CrmExcelColumn("企业产品编号")
  private String goodsCode;

  /**
   * 企业产品名称
   */
  @CrmExcelColumn("企业产品名称")
  private String goodsName;

  /**
   * 企业当前单位
   */
  @CrmExcelColumn("企业当前单位")
  private String curCompanyUnit;

  /**
   * 企业单位数量
   */
  @CrmExcelColumn("企业当前单位销售数量")
  private BigDecimal curCompanyUnitOrderQuantity;

  /**
   * 销售金额
   */
  @CrmExcelColumn("销售金额")
  private BigDecimal salesAmount;

  /**
   * 销售成本
   */
  @CrmExcelColumn("销售成本")
  private BigDecimal salesCost;

  /**
   * 产品规格
   */
  @CrmExcelColumn("产品规格")
  private String specification;

  /**
   * 登录账号
   */
  @CrmExcelColumn("登录账号")
  private String userName;

  /**
   * 创建时间
   */
  @CrmExcelColumn("创建时间")
  private String createTime;

  /**
   * 创建用户
   */
  @CrmExcelColumn("创建用户")
  private String createName;

  /**
   * 创建时间
   */
  @CrmExcelColumn("创建时间")
  private String modifyTime;
}
