package com.biz.crm.kms.admin.web.exports.vo;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelExport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import io.swagger.annotations.ApiModel;
import lombok.Data;

/**
 * 商超门店信息导出vo
 *
 * @author ning.zhang
 * @date 2022/9/23
 */
@Data
@CrmExcelExport
@ApiModel(value = "SupermarketStoreExportVo", description = "商超门店信息导出vo")
public class SupermarketStoreExportVo extends CrmExcelVo {

  /**
   * 门店编码
   */
  @CrmExcelColumn("门店编码")
  private String storeCode;

  /**
   * 门店名称
   */
  @CrmExcelColumn("门店名称")
  private String storeName;

  /**
   * 门店所属大区
   */
  @CrmExcelColumn("门店所属大区")
  private String storeAreaName;

  /**
   * 商超名称
   */
  private String supermarketName;

  /**
   * 商超区域名称
   */
  private String supermarketAreaName;
}
