package com.biz.crm.kms.admin.web.imports.model;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelImport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * 直营上架产品导入vo
 *
 * @author pengxi
 * @date 2022/10/9
 */
@Data
@CrmExcelImport
public class DirectProductImportVo extends CrmExcelVo {

  /**
   * 系统编码
   */
  @CrmExcelColumn("*系统编码")
  private String directCode;

  /**
   * 送达方编码
   */
  @CrmExcelColumn("送达方编码")
  private String deliveryPartyCode;

  /**
   * 送达方名称
   */
  @CrmExcelColumn("送达方名称")
  private String deliveryPartyName;

  /**
   * 售达方编码
   */
  @CrmExcelColumn("售达方编码")
  private String sellPartyCode;

  /**
   * 售达方名称
   */
  @CrmExcelColumn("售达方名称")
  private String sellPartyName;

  /**
   * 产品编码
   */
  @CrmExcelColumn("*产品编码")
  private String productCode;

  /**
   * 零售商产品编码
   */
  @CrmExcelColumn("*零售商产品编码")
  private String kaProductCode;
  /**
   * 零售商产品名称
   */
  @CrmExcelColumn("*零售商产品名称")
  private String kaProductName;

  /**
   * 是否默认物料（0：否，1：是）
   */
  @CrmExcelColumn("*是否默认产品")
  private String isDefault;

  /**
   * 上下架（0：下架，1：上架）
   */
  @CrmExcelColumn("*上下架")
  private String onShelfStatus;

  /**
   * 单据类型
   */
  @CrmExcelColumn("*单据类型")
  private String orderType;


  @ExcelIgnore
  private List<String> orderTypeList;

  /**
   * 企业产品单位编码
   */
  @CrmExcelColumn("*产品单位编码")
  private String unitCode;

  /**
   * 企业产品单位名称
   */
  @CrmExcelColumn("*产品单位名称")
  private String unitName;

  /**
   * 企业单位数量
   */
  @CrmExcelColumn("*单位数量")
  private String unitQuantityStr;

  /**
   * 零售商单位数量
   */
  @CrmExcelColumn("*零售商单位数量")
  private String kaUnitQuantityStr;

  /**
   * 零售商产品单位编码
   */
  @CrmExcelColumn("零售商产品单位名称")
  private String kaUnitCode;
}

