package com.biz.crm.kms.admin.web.imports.model;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelImport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 直营门店导入Vo
 *
 * @author ning.zhang
 * @date 2022/10/9
 */
@Data
@CrmExcelImport(startRow = 2)
public class DirectStoreImportVo extends CrmExcelVo {

  /**
   * 系统编码
   */
  @CrmExcelColumn("*系统编码")
  private String directCode;

  /**
   * 企业门店编码
   */
  @CrmExcelColumn("送达方编码")
  private String terminalCode;

  /**
   * 企业门店名称
   */
  @CrmExcelColumn("送达方名称")
  private String terminalName;

  /**
   * 售达方编码
   */
  @CrmExcelColumn("售达方编码")
  private String soldToPartyCode;

  /**
   * 售达方名称
   */
  @CrmExcelColumn("售达方名称")
  private String soldToPartyName;

  /**
   * 客户门店编码
   */
  @CrmExcelColumn("*客户门店编码")
  private String supermarketStoreCode;

  /**
   * 客户门店名称
   */
  @CrmExcelColumn("*客户门店名称")
  private String storeName;

  /**
   * 对账时间阈值
   */
  @CrmExcelColumn("*对账时间阈值")
  private String timeThreshold;

  /**
   * 数据来源
   */
  private String sourceType;
}
