package com.biz.crm.kms.admin.web.imports.model;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelImport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import lombok.Data;

/**
 * 商超订货单导入Vo
 *
 * @author ning.zhang
 * @date 2022/11/3
 */
@Data
@CrmExcelImport
public class SupermarketOrderImportVo extends CrmExcelVo {

  /**
   * 系统编号
   */
  @CrmExcelColumn("*系统编号")
  private String directCode;

  /**
   * 系统名称
   */
  @CrmExcelColumn("*系统名称")
  private String kaName;

  /**
   * 商超订单编号
   */
  @CrmExcelColumn("*商超订单编号")
  private String kaOrderNumber;

  /**
   * 商超门店编号
   */
  @CrmExcelColumn("*商超门店编号")
  private String kaStoreCode;

  /**
   * 商超门店名称
   */
  @CrmExcelColumn("*商超门店名称")
  private String kaStoreName;

  /**
   * 订单日期
   */
  @CrmExcelColumn("*订单日期")
  private String orderDate;

  /**
   * 交货日期
   */
  @CrmExcelColumn("交货日期")
  private String deliveryDate;

  /**
   * 订货单总金额（不含税）
   */
  @CrmExcelColumn("订货单总金额（不含税）")
  private String finalOrderAmountNot;

  /**
   * 订货单总金额（含税）
   */
  @CrmExcelColumn("*订货单总金额（含税）")
  private String finalOrderAmount;

  /**
   * 商超产品编号
   */
  @CrmExcelColumn("*商超产品编号")
  private String kaGoodsCode;

  /**
   * 商超产品名称
   */
  @CrmExcelColumn("*商超产品名称")
  private String kaGoodsName;

  /**
   * 产品国际条码
   */
  @CrmExcelColumn("产品国际条码")
  private String goodsBarCode;

  /**
   * 商超单位
   */
  @CrmExcelColumn("*商超单位")
  private String curUnit;

  /**
   * 商超数量
   */
  @CrmExcelColumn("*商超数量")
  private String curUnitOrderQuantity;

  /**
   * 产品规格
   */
  @CrmExcelColumn("产品规格")
  private String specification;

  /**
   * 商超订货单价
   */
  @CrmExcelColumn("*商超订货单价")
  private String unitPrice;

  /**
   * 商超订货金额（含税）
   */
  @CrmExcelColumn("*商超订货金额（含税）")
  private String orderAmount;


  /**
   * 商超订货金额（不含税）
   */
  @CrmExcelColumn("商超订货金额（不含税）")
  private String orderAmountNot;
}
