package com.biz.crm.kms.admin.web.imports.model;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelImport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import lombok.Data;

/**
 * 商超门店信息导入
 *
 * @author ning.zhang
 * @date 2022/9/23
 */
@Data
@CrmExcelImport
public class SupermarketStoreImportVo extends CrmExcelVo {



  /**
   * 商超编码
   */
  @CrmExcelColumn("*零售商名称")
  private String supermarketName;
  /**
   * 零售商门店编码
   */
  @CrmExcelColumn("*零售商门店编码")
  private String storeCode;

  /**
   * 零售商门店名称
   */
  @CrmExcelColumn("*零售商门店名称")
  private String storeName;


  /**
   * 商超区域编码
   */
  @CrmExcelColumn("门店所属大区")
  private String supermarketAreaCode;

  /**
   * 门店/仓
   */
  @CrmExcelColumn("门店/仓")
  private String kaStoreName;
}
