package com.biz.crm.kms.admin.web.imports.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.kms.admin.web.imports.model.DirectProductImportVo;
import com.biz.crm.kms.business.direct.product.local.entity.DirectProductEntity;
import com.biz.crm.kms.business.direct.product.local.entity.DirectProductUnitEntity;
import com.biz.crm.kms.business.direct.product.sdk.dto.DirectProductDto;
import com.biz.crm.kms.business.direct.product.sdk.dto.DirectProductUnitDto;
import com.biz.crm.kms.business.direct.product.sdk.service.DirectProductVoService;
import com.biz.crm.kms.business.direct.product.sdk.vo.DirectProductVo;
import com.biz.crm.kms.business.direct.sdk.service.DirectVoService;
import com.biz.crm.kms.business.direct.sdk.vo.DirectVo;
import com.biz.crm.kms.business.direct.store.sdk.dto.DirectStoreConditionDto;
import com.biz.crm.kms.business.direct.store.sdk.service.DirectStoreVoService;
import com.biz.crm.kms.business.direct.store.sdk.vo.DirectStoreVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mdm.business.product.sdk.dto.ProductQueryDto;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 直营上架产品导入
 *
 * @author pengxi
 * @date 2022/10/9
 */
@Component
@Slf4j
public class DirectProductImportProcess implements ImportProcess<DirectProductImportVo> {

    @Autowired(required = false)
    private ProductVoService productVoService;
    @Autowired(required = false)
    private DirectProductVoService directProductVoService;
    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required = false)
    private DirectStoreVoService directStoreVoService;

    @Autowired(required = false)
    private DictDataVoService dictDataVoService;

    @Autowired(required = false)
    private DirectVoService directVoService;

    /**
     * 表示当前导入excel中无论多少条数据，分批处理过程每次处理多少条数据
     */
    @Override
    public Integer getBatchCount() {
        return 10000;
    }

    @Override
    @Transactional
    public Map<Integer, String> execute(LinkedHashMap<Integer, DirectProductImportVo> data
            , TaskGlobalParamsVo taskGlobalParamsVo
            , Map<String, Object> map) {
        if (CollectionUtils.isEmpty(data.values())) {
            return Maps.newHashMap();
        }
        log.info("数据：{}", data.values());
        Map<Integer, String> response = Maps.newHashMap();
        //商品编码
        Set<String> productCodes = Sets.newHashSet();
        //系统编码
        Set<String> directCodes = Sets.newHashSet();
        //送达方编码
        Set<String> deliveryPartyCodes = Sets.newHashSet();
        //ka商品编码
        Set<String> kaProductCodes = Sets.newHashSet();
        //售达方编码
        Set<String> sellPartyCodes = Sets.newHashSet();
        //售达方map
        Map<String,List<DirectStoreVo>> sellStoreMap = Maps.newHashMap();
        //组装数据
        for(DirectProductImportVo vo : data.values()){
            if(StringUtils.isNotEmpty(vo.getProductCode())){
                productCodes.add(vo.getProductCode());
            }
            if(StringUtils.isNotEmpty(vo.getDirectCode())){
                directCodes.add(vo.getDirectCode());
            }
            if(StringUtils.isNotEmpty(vo.getDeliveryPartyCode())){
                deliveryPartyCodes.add(vo.getDeliveryPartyCode());
            }else if(StringUtils.isNotEmpty(vo.getSellPartyCode())){
                sellPartyCodes.add(vo.getSellPartyCode());
            }
            if(StringUtils.isNotEmpty(vo.getKaProductCode())){
                kaProductCodes.add(vo.getKaProductCode());
            }
        }
        List<DirectStoreVo> itemStoreList = Lists.newArrayList();
        //查询售达方下面的所有送达方
        if(CollectionUtils.isNotEmpty(sellPartyCodes) &&
                CollectionUtils.isNotEmpty(directCodes)){
            DirectStoreConditionDto storeDto = new DirectStoreConditionDto();
            storeDto.setDirectCodes(directCodes);
            storeDto.setSoldToPartyCodes(sellPartyCodes);
            storeDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            storeDto.setEnableStatus(DelFlagStatusEnum.NORMAL.getCode());
            List<DirectStoreVo> storeVoList = directStoreVoService.findByDirectStoreConditionDto(storeDto);
            if(CollectionUtils.isNotEmpty(storeVoList)){
                for(DirectStoreVo storeVo : storeVoList){
                    deliveryPartyCodes.add(storeVo.getTerminalCode());
                    if(sellStoreMap.get(storeVo.getSoldToPartyCode())==null){
                        itemStoreList = Lists.newArrayList();
                        itemStoreList.add(storeVo);
                        sellStoreMap.put(storeVo.getSoldToPartyCode(),itemStoreList);
                    }else{
                        itemStoreList = sellStoreMap.get(storeVo.getSoldToPartyCode());
                        itemStoreList.add(storeVo);
                        sellStoreMap.put(storeVo.getSoldToPartyCode(),itemStoreList);
                    }
                }
            }
        }
        Map<String,String> productMap = Maps.newHashMap();
        //查询KMS商品信息
        if(CollectionUtils.isNotEmpty(productCodes)
                && CollectionUtils.isNotEmpty(directCodes)
                && CollectionUtils.isNotEmpty(deliveryPartyCodes)
                && CollectionUtils.isNotEmpty(kaProductCodes)){
            DirectProductDto productDto = new DirectProductDto();
            productDto.setProductCodes(new ArrayList<>(productCodes));
            productDto.setDirectCodes(new ArrayList<>(directCodes));
            productDto.setDeliveryPartyCodes(new ArrayList<>(deliveryPartyCodes));
            productDto.setKaProductCodes(new ArrayList<>(kaProductCodes));
            productDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            productDto.setEnableStatus(DelFlagStatusEnum.NORMAL.getCode());
            List<DirectProductVo> productVoList = directProductVoService.findByListConditions(productDto);
            if(CollectionUtils.isNotEmpty(productVoList)){
                for(DirectProductVo productVo : productVoList){
                    //判断是否为默认产品,如果是默认产品，则校验是否存在
                    if (BooleanEnum.TRUE.getCapital().equals(productVo.getIsDefault())) {
                        if (productMap.get(productVo.getDirectCode() + "_" + productVo.getDeliveryPartyCode() + "_"
                                + productVo.getProductCode() + "_" + productVo.getKaProductCode()) == null) {
                            productMap.put(productVo.getDirectCode() + "_" + productVo.getDeliveryPartyCode() + "_"
                                    + productVo.getProductCode() + "_" + productVo.getKaProductCode(), "1");
                        }
                    }
                }
            }
        }
        //查询商品信息
        List<ProductVo> productVos  = Lists.newArrayList();
        try {
            ProductQueryDto dto = new ProductQueryDto();
            dto.setProductCodeList(new ArrayList<>(productCodes));
            productVos = this.productVoService.findByQueryDto(dto);
        } catch (Exception e) {
            log.error("查询MDM商品信息错误", e);
        }
        log.info("查询mdm商品信息结束，productVos={}", productVos);
        Map<String, ProductVo> productVoMap = Maps.newHashMap();
        if(CollectionUtils.isNotEmpty(productVos)){
            productVoMap = productVos.stream().collect(Collectors.toMap(ProductVo::getProductCode, Function.identity()));
        }else{
            log.error("未查询到MDM商品信息！");
        }
        // 查询单据类型数据字典
        List<DictDataVo> dictDatas = dictDataVoService.findByDictTypeCode("kms_parameter_order_type");
        Map<String, String> orderTypeMap = Maps.newHashMap();
        if(CollectionUtils.isNotEmpty(dictDatas)){
            orderTypeMap = dictDatas.stream().collect(Collectors.toMap(DictDataVo::getDictValue, DictDataVo::getDictCode));
        }
        List<DirectVo> directVoList = this.directVoService.findByDirectCodes(new ArrayList<>(directCodes));
        Map<String, DirectVo> directVoMap = Maps.newHashMap();
        if(CollectionUtils.isNotEmpty(directVoList)){
            directVoMap = directVoList.stream().collect(Collectors.toMap(DirectVo::getDirectCode, Function.identity(), (a, b) -> a));
        }
        //遍历需导入的数据，校验并保存
        Map<String,String> importMap = Maps.newHashMap();
        List<String> orderTypeList  = Lists.newArrayList();
        StringBuilder error = new StringBuilder();
        List<DirectProductDto> dtoList = Lists.newArrayList();
        List<DirectProductUnitDto> directProductUnitDtoList = Lists.newArrayList();
        //遍历数据，检查
        List<DirectStoreVo> soldPartyCodeList = Lists.newArrayList();
        DirectStoreVo directStoreVo = new DirectStoreVo();
        for(Map.Entry<Integer, DirectProductImportVo> importVo :data.entrySet()){
            Integer index = importVo.getKey();
            DirectProductImportVo vo = importVo.getValue();
            error = new StringBuilder();
//            if(importMap.get(vo.getDirectCode()+"_"
//                    +vo.getProductCode()+"_"
//                    +vo.getKaProductCode())==null){
//                importMap.put(vo.getProductCode(),"1");
//            }else{
//                error.append("导入数据中出现重复数据！");
//            }
            if(StringUtils.isEmpty(vo.getDirectCode())){
                error.append("系统编码不能为空！");
            }
            if(StringUtils.isEmpty(vo.getSellPartyCode())){
                error.append("售达方编码不能为空！");
            }
            if(StringUtils.isEmpty(vo.getSellPartyName())){
                error.append("售达方名称不能为空！");
            }
            if(StringUtils.isEmpty(vo.getProductCode())){
                error.append("产品编码不能为空！");
            }
            if(StringUtils.isEmpty(vo.getKaProductCode())){
                error.append("零售商产品编码不能为空！");
            }
            if(StringUtils.isEmpty(vo.getIsDefault())){
                error.append("是否默认产品不能为空！");
            }else{
                if(!BooleanEnum.TRUE.getCapital().equals(vo.getIsDefault())
                        && !BooleanEnum.FALSE.getCapital().equals(vo.getIsDefault())){
                    error.append("是否默认产品填写错误！");
                }
            }
            if(StringUtils.isEmpty(vo.getOnShelfStatus())){
                error.append("是否上下架不能为空！");
            }else{
                if(!BooleanEnum.TRUE.getCapital().equals(vo.getOnShelfStatus())
                        && !BooleanEnum.FALSE.getCapital().equals(vo.getOnShelfStatus())){
                    error.append("是否上下架填写错误！");
                }
            }
            if(StringUtils.isEmpty(vo.getOrderType())){
                error.append("单据类型不能为空！");
            }else{
                String[] orderTypes = vo.getOrderType().split(",");
                if(orderTypes.length>0){
                    orderTypeList = Lists.newArrayList();
                    for(String orderType : orderTypes){
                        if(orderTypeMap.get(orderType)!=null){
                            orderTypeList.add(orderTypeMap.get(orderType));
                        }else{
                            error.append("单据类型填写错误！");
                        }
                    }
                    if(CollectionUtils.isNotEmpty(orderTypeList)){
                        vo.setOrderTypeList(orderTypeList);
                    }
                }else{
                    error.append("单据类型填写错误！");
                }
            }
            if(StringUtils.isEmpty(vo.getUnitCode())){
                error.append("产品单位编码不能为空！");
            }
            if(StringUtils.isEmpty(vo.getUnitName())){
                error.append("产品单位名称不能为空！");
            }
            if(StringUtils.isEmpty(vo.getUnitQuantityStr())){
                error.append("单位数量不能为空！");
            }
            if(StringUtils.isEmpty(vo.getKaUnitQuantityStr())){
                error.append("零售商单位数量不能为空！");
            }
//            if(StringUtils.isEmpty(vo.getKaUnitCode())){
//                error.append("零售商产品单位名称不能为空！");
//            }
            // 记录错误信息
            if (error.length() > 0) {
                response.put(index, error.toString());
                continue;
            }

            if(StringUtils.isNotEmpty(vo.getDeliveryPartyCode())){
                soldPartyCodeList = Lists.newArrayList();
                directStoreVo = new DirectStoreVo();
                directStoreVo.setTerminalCode(vo.getDeliveryPartyCode());
                directStoreVo.setTerminalName(vo.getDeliveryPartyName());
                soldPartyCodeList.add(directStoreVo);
            }else{
                soldPartyCodeList = sellStoreMap.get(vo.getSellPartyCode());
            }
            if(CollectionUtils.isNotEmpty(soldPartyCodeList)){
                for(DirectStoreVo storeVo : soldPartyCodeList){

                    log.info("key={}",vo.getDirectCode()+"_"+storeVo.getTerminalCode()+"_"
                            +vo.getProductCode()+"_"+vo.getKaProductCode());

                        if (importMap.get(vo.getDirectCode() + "_" + storeVo.getTerminalCode() + "_"
                                + vo.getProductCode() + "_" + vo.getKaProductCode()) == null) {
                            importMap.put(vo.getDirectCode() + "_" + storeVo.getTerminalCode() + "_"
                                    + vo.getProductCode() + "_" + vo.getKaProductCode(), "1");
                        } else {
                            error.append("该商品已存在，请检查数据。");
                            response.put(index, error.toString());
                            continue;
                        }

                    if(productMap.get(vo.getDirectCode()+"_"+storeVo.getTerminalCode()+"_"
                            +vo.getProductCode()+"_"+vo.getKaProductCode())!=null){
                        error.append("该商品已存在，请检查数据。");
                        response.put(index, error.toString());
                        continue;
                    }
                    DirectProductDto dto = this.nebulaToolkitService.copyObjectByWhiteList(vo, DirectProductDto.class, HashSet.class, ArrayList.class);
                    dto.setId(UUID.randomUUID().toString().replaceAll("-",""));
                    dto.setDeliveryPartyCode(storeVo.getTerminalCode());
                    dto.setDeliveryPartyName(storeVo.getTerminalName());
                    dto.setSellPartyCode(vo.getSellPartyCode());
                    dto.setSellPartyName(vo.getSellPartyName());
                    dto.setTenantCode(taskGlobalParamsVo.getTenantCode());
                    dto.setCreateAccount(taskGlobalParamsVo.getCreateAccount());
                    dto.setCreateName(taskGlobalParamsVo.getCreateAccountName());
                    dto.setCreateTime(taskGlobalParamsVo.getTaskCreateTime());
                    dto.setModifyAccount(taskGlobalParamsVo.getCreateAccount());
                    dto.setModifyName(taskGlobalParamsVo.getCreateAccountName());
                    dto.setModifyTime(taskGlobalParamsVo.getTaskCreateTime());
                    if(productVoMap.get(dto.getProductCode())!=null){
                        dto.setProductName(productVoMap.get(dto.getProductCode()).getProductName());
                    }
                    DirectVo directVo = directVoMap.get(vo.getDirectCode());
                    if(directVo != null){
                        dto.setBusinessFormatCode(directVo.getBusinessFormatCode());
                        dto.setBusinessUnitCode(directVo.getBusinessUnitCode());
                    }
                    BigDecimal kaUnitQuantity = BigDecimal.ZERO;
                    BigDecimal unitQuantity = BigDecimal.ZERO;
                    try{
                        kaUnitQuantity = new BigDecimal(vo.getKaUnitQuantityStr());
                        unitQuantity = new BigDecimal(vo.getUnitQuantityStr());
                    }catch (Exception e){
                        error.append("数量填写错误！");
                        response.put(index,error.toString());
                    }
                        directProductUnitDtoList = Lists.newArrayList();
                        if(CollectionUtils.isNotEmpty(vo.getOrderTypeList())){
                            for(String orderType : vo.getOrderTypeList()){
                                DirectProductUnitDto unitDto = this.nebulaToolkitService.copyObjectByWhiteList(vo, DirectProductUnitDto.class, HashSet.class, ArrayList.class);
                                unitDto.setOrderType(orderType);
                                unitDto.setKaUnitQuantity(kaUnitQuantity);
                                unitDto.setUnitQuantity(unitQuantity);
                                unitDto.setDirectProductId(dto.getId());
                                directProductUnitDtoList.add(unitDto);
                            }
                            dto.setUnitList(directProductUnitDtoList);
                        }else{
                            error.append("单据类型不存在！");
                            response.put(index, error.toString());
                            continue;
                        }
                        dto.setSourceType("手工导入");
                        dtoList.add(dto);


                }
            }
        }
        this.directProductVoService.importBatch(dtoList);
        return response;
    }

    @Override
    public Class<DirectProductImportVo> findCrmExcelVoClass() {
        return DirectProductImportVo.class;
    }

    @Override
    public String getTemplateCode() {
        return "KMS_DIRECT_PRODUCT_IMPORT";
    }

    @Override
    public String getTemplateName() {
        return "KMS上架产品导入";
    }
}
