package com.biz.crm.kms.admin.web.imports.service;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.kms.admin.web.imports.model.DirectStoreImportVo;
import com.biz.crm.kms.business.direct.store.local.service.DirectStoreService;
import com.biz.crm.kms.business.direct.store.sdk.dto.DirectStoreDto;
import com.biz.crm.mdm.business.terminal.sdk.service.TerminalVoService;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 直营门店信息导入
 *
 * @author ning.zhang
 * @date 2022/10/9
 */
@Slf4j
@Component
public class DirectStoreImportProcess implements ImportProcess<DirectStoreImportVo> {

  @Autowired
  private DirectStoreService directStoreService;
  @Autowired(required = false)
  private TerminalVoService terminalVoService;


  @Override
  public Map<Integer, String> execute(LinkedHashMap<Integer, DirectStoreImportVo> data
      , TaskGlobalParamsVo taskGlobalParamsVo
      , Map<String, Object> map) {
    if (CollectionUtils.isEmpty(data.values())) {
      return Maps.newHashMap();
    }
    log.info("门店导入测试！数据为:{}",data.values());
    //送达方编码集合
    log.info("开始查询售达方!");
    List<TerminalVo> terminalVos = this.terminalVoService.findDetailsByIdsOrTerminalCodes(null,data.values().stream().map(DirectStoreImportVo::getTerminalCode).distinct().collect(Collectors.toList()));
    Validate.isTrue(CollectionUtils.isNotEmpty(terminalVos),"未查询到对应的送达方");
    Map<String , TerminalVo> deliveryMap = terminalVos.stream().collect(Collectors.toMap(TerminalVo::getTerminalCode, Function.identity()));
    log.info("门店数据为:{}",deliveryMap.values());
    log.info("查询售达方结束!");
    data.forEach((index, importVo)->{
      log.info("开始处理数据!：{}", JSONObject.toJSON(importVo));
      DirectStoreDto dto = this.copyToStoreDto(importVo);
      Validate.isTrue(StringUtils.isNotBlank(importVo.getTerminalCode()),"送达方编码不能为空");
      TerminalVo deliveryWayVo = deliveryMap.get(importVo.getTerminalCode());
      log.info("开始填充数据!");
      if (Objects.nonNull((deliveryWayVo))){
//        if (StringUtils.isNotEmpty(deliveryWayVo.getSellerCode())){
//          dto.setTerminalName(deliveryWayVo.getTerminalName());
//          dto.setSoldToPartyCode(deliveryWayVo.getSellerCode());
//          dto.setSoldToPartyName(deliveryWayVo.getSellerName());
//          log.info("数据展示：{}",dto);
//        }else {
//          throw new IllegalArgumentException("未找到该送达方所属的售达方!");
//        }
        //取消售达方校验，如需校验，取消注释上面代码，注释下面代码
          dto.setTerminalName(deliveryWayVo.getTerminalName());
          Validate.isTrue(StringUtils.isNotBlank(dto.getSoldToPartyCode()),"售达方编码不能为空");
          Validate.isTrue(StringUtils.isNotBlank(dto.getSoldToPartyName()),"售达方名称不能为空");
          log.info("数据展示：{}",dto);
      }else {
        throw new IllegalArgumentException("未找到该送达方!");
      }
      try {
        dto.setTimeThreshold(Integer.valueOf(importVo.getTimeThreshold()));
      } catch (Exception e) {
        throw new IllegalArgumentException("对账时间阈值数据错误!");
      }
      dto.setSourceType("手动导入");
      log.info("开始校验保存数据!");
      this.directStoreService.create(dto);
    });
    return Maps.newHashMap();
  }

  @Override
  public Class<DirectStoreImportVo> findCrmExcelVoClass() {
    return DirectStoreImportVo.class;
  }

  @Override
  public String getTemplateCode() {
    return "KMS_DIRECT_STORE_IMPORT";
  }

  @Override
  public String getTemplateName() {
    return "直营门店导入";
  }

  /**
   * 对象赋值
   * @param importVo
   * @return
   */
  private DirectStoreDto copyToStoreDto(DirectStoreImportVo importVo){
    DirectStoreDto dto = new DirectStoreDto();
    dto.setDirectCode(importVo.getDirectCode());
    dto.setTerminalCode(importVo.getTerminalCode());
    dto.setTerminalName(importVo.getTerminalName());
    dto.setSupermarketStoreCode(importVo.getSupermarketStoreCode());
    dto.setSoldToPartyCode(importVo.getSoldToPartyCode());
    dto.setSoldToPartyName(importVo.getSoldToPartyName());
    return dto;
  }
}
