package com.biz.crm.kms.admin.web.imports.service;

import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.kms.admin.web.imports.model.SupermarketStoreImportVo;
import com.biz.crm.kms.business.supermarket.sdk.service.SupermarketVoService;
import com.biz.crm.kms.business.supermarket.sdk.vo.SupermarketVo;
import com.biz.crm.kms.business.supermarket.store.local.service.SupermarketStoreService;
import com.biz.crm.kms.business.supermarket.store.sdk.dto.SupermarketStoreDto;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Maps;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 商超门店信息导入
 *
 * @author ning.zhang
 * @date 2022/9/23
 */
@Component
public class SupermarketStoreImportProcess implements ImportProcess<SupermarketStoreImportVo> {

  @Autowired
  private SupermarketStoreService supermarketStoreService;
  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;
  @Autowired(required = false)
  private SupermarketVoService supermarketVoService;

  @Override
  public Map<Integer, String> execute(LinkedHashMap<Integer, SupermarketStoreImportVo> data
      , TaskGlobalParamsVo taskGlobalParamsVo
      , Map<String, Object> map) {

    //先查出零售商的名称对应的编码
    List<SupermarketVo> supermarketVos = this.supermarketVoService.findBySupermaketNames(data.values().stream().map(SupermarketStoreImportVo::getSupermarketName).collect(Collectors.toSet()));
    Map<String ,SupermarketVo> supermarketMaps = supermarketVos.stream().collect(Collectors.toMap(SupermarketVo::getSupermarketName, Function.identity()));

    Collection<SupermarketStoreImportVo> supermarketStoreImportVos =data.values();
    List<SupermarketStoreDto> supermarketStoreDtos = new ArrayList<>();
    supermarketStoreImportVos.forEach(aa ->{
      SupermarketStoreDto supermarketStoreDto = this.nebulaToolkitService.copyObjectByWhiteList(aa,SupermarketStoreDto.class,HashSet.class,ArrayList.class);
      SupermarketVo supermarketVo = supermarketMaps.get(aa.getSupermarketName());
      Validate.isTrue(!Objects.isNull(supermarketVo),"该零售商不存在");
      supermarketStoreDto.setSupermarketCode(supermarketVo.getSupermarketCode());
      supermarketStoreDtos.add(supermarketStoreDto);
    });
    supermarketStoreDtos.forEach(v ->{
      this.validate(v);
      this.supermarketStoreService.create(v);
    });

    return Maps.newHashMap();
  }

  /**
   * 零售商门店校验
   * @param dto
   */
  private void validate(SupermarketStoreDto dto){
    Validate.notNull(dto, "进行当前操作时，信息对象必须传入!");
    Validate.notBlank(dto.getStoreCode(), "缺失零售商门店编码");
    Validate.notBlank(dto.getStoreName(), "缺失零售商门店名称");
    Validate.notBlank(dto.getSupermarketCode(), "缺失零售商编码");
  }

  @Override
  public Class<SupermarketStoreImportVo> findCrmExcelVoClass() {
    return SupermarketStoreImportVo.class;
  }

  @Override
  public String getTemplateCode() {
    return "KMS_SUPERMARKET_STORE_IMPORT";
  }

  @Override
  public String getTemplateName() {
    return "零售商门店导入";
  }
}
