package com.biz.crm.kms.admin.web.login;

import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mn.common.rocketmq.service.MqDemoMsgExtendService;
import com.biz.crm.mn.common.rocketmq.vo.MqMessageVo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;


/**
 * 阿里 rocketMq
 *
 * @describe: MQ
 * @author: huxmld
 * @version: v1.0.0
 * @date: 2022/10/16 17:14
 */
@Slf4j
@Service
public class RocketDemoServiceImpl implements MqDemoMsgExtendService {

    @Autowired(required = false)
    private LoginUserService loginUserService;
    @Autowired(required = false)
    private DictDataVoService dictDataVoService;

    @Override
    public void rocketMqDemoConsumer(MqMessageVo message) {
        log.info("{}", loginUserService.getAbstractLoginUser());
        List<DictDataVo> d = dictDataVoService.findByDictTypeCode("yes_or_no");
        log.info("{}", d);
    }

    @Override
    public void rocketMqOrderDemoConsumer(MqMessageVo message) {
        log.info("{}", loginUserService.getAbstractLoginUser());
        List<DictDataVo> d = dictDataVoService.findByDictTypeCode("yes_or_no");
        log.info("{}", d);
    }
}
