package com.biz.crm.kms.admin.web.login.notifier;

import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.bizunited.nebula.common.service.redis.RedisMutexService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;

/**
 * @description: 默认编码规则
 * @author: songjingen
 */
@Service
public class DefaultGenerateCodeServiceImpl implements GenerateCodeService {

  @Autowired
  private RedisMutexService redisMutexService;

  @Override
  public List<String> generateCode(String ruleCode, int number) {
    String nowTimeStr = DateFormatUtils.format(new Date(), "yyyyMMdd");
    List<String> codes = Lists.newArrayList();
    String key = String.format(KEY_FORMAT, ruleCode, TenantUtils.getTenantCode());
    for (int i = 0; i < number; i++) {
      String index = redisMutexService.getAndIncrement(key, 1, 8);
      codes.add(StringUtils.join(ruleCode, nowTimeStr, index));
    }
    return codes;
  }

  @Override
  public List<String> generateCode(String ruleCode, int number, Integer mixStrLen, long expire, TimeUnit unit) {
    List<String> codes = Lists.newArrayList();
    String key = String.format(KEY_FORMAT, ruleCode, TenantUtils.getTenantCode());
    for (int i = 0; i < number; i++) {
      String index = redisMutexService.getAndIncrement(key, 1, mixStrLen, expire, unit);
      codes.add(StringUtils.join(ruleCode, index));
    }
    return codes;
  }

  /**
   * code生成规则
   */
  private final static String KEY_FORMAT = "%s:code:index:%s";
}