package com.biz.crm.kms.admin.web.login.task;

import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.kms.admin.web.login.DefaultAuthenticationDecisionStrategy;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.task.local.entity.DynamicTaskOperatorEntity;
import com.bizunited.nebula.task.local.repository.DynamicTaskOperatorRepository;
import com.bizunited.nebula.task.service.security.IndependencySecurity;
import com.bizunited.nebula.task.vo.DynamicTaskOperatorVo;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.LinkedHashSet;

/**
 * 当CRM后台管理系统boot，运行定时任务时，都是以厂商用户进行运行
 * @author yinwenjie
 */
@Component
public class DefaultIndependencySecurity extends DefaultAuthenticationDecisionStrategy implements IndependencySecurity {
  @Autowired
  private NebulaToolkitService nebulaToolkitService;
  @Autowired
  private DynamicTaskOperatorRepository dynamicTaskOperatorRepository;
  @Autowired
  private LoginUserService loginUserService;
  
  @Override
  public void independency(String taskCode, String appCode, String applicationName) {
    /*
     * 在默认的实现中，
     * 如果当前任务记录了操作者信息，则以这个信息为准，如果没有，则以security模块SimpleSecurityProperties中的相关属性为准
     * */
    
    DynamicTaskOperatorEntity dynamicTaskOperatorEntity = this.dynamicTaskOperatorRepository.findByDynamicTaskCodeAndApplicationName(taskCode, appCode, applicationName);
    DynamicTaskOperatorVo dynamicTaskOperatorVo = null;
    // 如果存在任务创建者的身份信息，则以任务创建者的操作信息为准
    if(dynamicTaskOperatorEntity != null) {
      dynamicTaskOperatorVo = this.nebulaToolkitService.copyObjectByWhiteList(dynamicTaskOperatorEntity, DynamicTaskOperatorVo.class, LinkedHashSet.class, ArrayList.class);
      dynamicTaskOperatorVo.setRoles(StringUtils.split(dynamicTaskOperatorEntity.getRoles(), ","));
    } 
    // 初始化这个任务线程的用户身份信息
    this.loginUserService.refreshAuthentication(dynamicTaskOperatorVo);
  }
}
