package com.biz.crm.kms.admin.web.reports.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.kms.admin.web.reports.service.AuditMatchInvoiceReportVoService;
import com.biz.crm.kms.admin.web.reports.vo.AuditMatchInvoiceReportVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 稽核匹配单据报表相关接口
 *
 * @author songjingen
 * @date 2022/11/10 16:22
 */
@RestController
@RequestMapping("/v1/report/auditMatchInvoiceReportVo")
@Api(tags = "稽核匹配单据：AuditMatchInvoiceReportVo：稽核匹配单据")
@Slf4j
public class AuditMatchInvoiceReportVoController {

  @Autowired
  private AuditMatchInvoiceReportVoService auditMatchInvoiceReportVoService;

  /**
   * 根据稽核编号查询稽核匹配单据列表
   */
  @GetMapping("findByAuditCode")
  @ApiOperation("根据稽核编号查询稽核匹配单据列表")
  public Result<List<AuditMatchInvoiceReportVo>> findByAuditCode(@ApiParam(name = "auditCode", value = "稽核单号") String auditCode) {
    try {
      return Result.ok(this.auditMatchInvoiceReportVoService.findByAuditCode(auditCode));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

}
