package com.biz.crm.kms.admin.web.reports.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.kms.admin.web.reports.dto.DirectStoreReportDto;
import com.biz.crm.kms.admin.web.reports.service.DirectStoreReportVoService;
import com.biz.crm.kms.admin.web.reports.vo.DirectStoreReportVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 直营门店: DirectStoreReportVo: 直营门店报表数据
 *
 * @author ning.zhang
 * @date 2022/10/11
 */
@Slf4j
@RestController
@RequestMapping("/v1/directStore/directStore")
@Api(tags = "直营门店: DirectStoreReportVo: 直营门店报表数据")
public class DirectStoreReportVoController {

  @Autowired
  private DirectStoreReportVoService directStoreReportVoService;

  /**
   * 直营门店分页列表
   *
   * @param dto      请求参数dto
   * @param pageable 分页信息
   * @return Page<DirectStoreReportVo> 直营门店分页信息
   */
  @ApiOperation(value = "直营门店分页列表")
  @GetMapping("/findByConditions")
  public Result<Page<DirectStoreReportVo>> findByConditions(@PageableDefault(50) Pageable pageable,
                                                                 @ApiParam(name = "DirectStoreReportDto", value = "参数Dto") DirectStoreReportDto dto) {
    try {
      return Result.ok(this.directStoreReportVoService.findByConditions(pageable, dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
