package com.biz.crm.kms.admin.web.reports.controller;


import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.kms.admin.web.reports.dto.DirectTreeDto;
import com.biz.crm.kms.admin.web.reports.service.DirectTreeVoService;
import com.biz.crm.kms.admin.web.reports.vo.DirectTreeVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 系统treeVo相关的http接口
 *
 * @author songjingen
 * @since 2022-09-26 16:31:55
 */
@RestController
@RequestMapping("/v1/report/directTreeVo")
@Slf4j
@Api(tags = "系统树状数据：DirectTreeVo：系统树状数据")
public class DirectTreeVoController {
  /**
   * 服务对象
   */
  @Autowired
  private DirectTreeVoService directTreeVoService;

  /**
   * 根据查询条件获取系统树状结构数据
   *
   * @param dto 主键
   * @return 满足条件的集合
   */
  @ApiOperation(value = "根据查询条件获取系统树状结构数据")
  @GetMapping("findByDirectTreeDto")
  public Result<List<DirectTreeVo>> findByDirectTreeDto(@ApiParam(name = "dto", value = "dto") DirectTreeDto dto) {
    try {
      List<DirectTreeVo> directTreeVos = this.directTreeVoService.findByDirectTreeDto(dto);
      return Result.ok(directTreeVos);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

}
