package com.biz.crm.kms.admin.web.reports.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 直营门店报表数据查询dto
 *
 * @author ning.zhang
 * @date 2022/10/12
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "DirectStoreReportDto", description = "直营门店报表数据查询dto")
public class DirectStoreReportDto extends TenantFlagOpDto {

  /**
   * 系统编码
   */
  @ApiModelProperty("系统编码")
  private String directCode;

  /**
   * 商超门店名称
   */
  @ApiModelProperty("商超门店名称")
  private String supermarketStoreName;

  /**
   * 企业门店名称
   */
  @ApiModelProperty("企业门店名称")
  private String terminalName;
}
