package com.biz.crm.kms.admin.web.reports.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.kms.admin.web.reports.dto.DirectStoreReportDto;
import com.biz.crm.kms.admin.web.reports.mapper.DirectStoreReportVoMapper;
import com.biz.crm.kms.admin.web.reports.vo.DirectStoreReportVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

/**
 * 直营门店报表数据数据库操作层
 *
 * @author ning.zhang
 * @date 2022/10/11
 */
@Component
public class DirectStoreReportVoRepository {

  @Autowired
  private DirectStoreReportVoMapper baseMapper;

  /**
   * 直营门店分页列表
   *
   * @param dto      请求参数dto
   * @param pageable 分页信息
   * @return Page<DirectStoreReportVo> 直营门店分页信息
   */
  public Page<DirectStoreReportVo> findByConditions(Pageable pageable, DirectStoreReportDto dto) {
    Page<DirectStoreReportVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return this.baseMapper.findByConditions(page, dto);
  }
}
