package com.biz.crm.kms.admin.web.reports.repository;

import com.biz.crm.kms.admin.web.reports.dto.DirectTreeDto;
import com.biz.crm.kms.admin.web.reports.mapper.DirectTreeVoMapper;
import com.biz.crm.kms.admin.web.reports.vo.DirectTreeVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 系统树状结构数据数据库操作层
 *
 * @author songjingen
 * @date 2022/9/27
 */
@Component
public class DirectTreeVoRepository {

  @Autowired
  private DirectTreeVoMapper directTreeVoMapper;

  /**
   * 根据查询条件获取系统树状结构数据
   *
   * @param dto 主键
   * @return 满足条件的集合
   */
  public List<DirectTreeVo> findByDirectTreeDto(DirectTreeDto dto) {
    return this.directTreeVoMapper.findByDirectTreeDto(dto);
  }
}
