package com.biz.crm.kms.admin.web.reports.service.internal;

import com.biz.crm.kms.admin.web.reports.service.AuditMatchInvoiceReportVoService;
import com.biz.crm.kms.admin.web.reports.vo.AuditMatchInvoiceReportVo;
import com.biz.crm.kms.business.audit.match.local.entity.AuditMatchInvoice;
import com.biz.crm.kms.business.audit.match.local.repository.AuditMatchInvoiceRepository;
import com.biz.crm.kms.business.invoice.sdk.strategy.InvoiceStatisticsStrategy;
import com.biz.crm.kms.business.invoice.sdk.vo.InvoiceStatisticsVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

/**
 * 稽核匹配单据service实现类
 *
 * @author songjingen
 * @date 2022/11/10 16:31
 */
@Service
public class AuditMatchInvoiceReportVoServiceImpl implements AuditMatchInvoiceReportVoService {

  @Autowired(required = false)
  private AuditMatchInvoiceRepository auditMatchInvoiceRepository;

  @Autowired(required = false)
  private List<InvoiceStatisticsStrategy> invoiceStatisticsStrategies;

  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;

  @Override
  public List<AuditMatchInvoiceReportVo> findByAuditCode(String auditCode) {
    if (StringUtils.isBlank(auditCode) || CollectionUtils.isEmpty(this.invoiceStatisticsStrategies)) {
      return new ArrayList<>(0);
    }
    List<AuditMatchInvoice> auditMatchInvoices = this.auditMatchInvoiceRepository.findByAuditCode(auditCode);
    if (CollectionUtils.isEmpty(auditMatchInvoices)) {
      return new ArrayList<>(0);
    }
    List<InvoiceStatisticsVo> invoiceStatisticsVos = new ArrayList<>();
    Map<String, List<String>> invoiceCodesMap = auditMatchInvoices.stream()
        .collect(Collectors.groupingBy(AuditMatchInvoice::getInvoiceType, Collectors.mapping(AuditMatchInvoice::getInvoiceCode, Collectors.toList())));
    for (InvoiceStatisticsStrategy invoiceStatisticsStrategy : this.invoiceStatisticsStrategies) {
      List<String> invoiceCodes = invoiceCodesMap.get(invoiceStatisticsStrategy.getType());
      if (CollectionUtils.isEmpty(invoiceCodes)) {
        continue;
      }
      List<InvoiceStatisticsVo> statisticsVos = invoiceStatisticsStrategy.findByInvoiceCodes(invoiceCodes);
      invoiceStatisticsVos.addAll(statisticsVos);
    }
    //组装数据
    List<AuditMatchInvoiceReportVo> reportVos = new ArrayList<>();
    Map<String, String> idMap = auditMatchInvoices.stream().collect(Collectors.toMap(o -> StringUtils.join(o.getInvoiceType(), o.getInvoiceCode()), AuditMatchInvoice::getId));
    for (InvoiceStatisticsVo invoiceStatisticsVo : invoiceStatisticsVos) {
      AuditMatchInvoiceReportVo reportVo = this.nebulaToolkitService.copyObjectByWhiteList(invoiceStatisticsVo, AuditMatchInvoiceReportVo.class, HashSet.class, ArrayList.class);
      reportVo.setId(idMap.get(StringUtils.join(invoiceStatisticsVo.getInvoiceType(), invoiceStatisticsVo.getInvoiceCode())));
      reportVos.add(reportVo);
    }
    return reportVos;
  }
}
