package com.biz.crm.kms.admin.web.reports.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.kms.admin.web.reports.dto.DirectStoreReportDto;
import com.biz.crm.kms.admin.web.reports.repository.DirectStoreReportVoRepository;
import com.biz.crm.kms.admin.web.reports.service.DirectStoreReportVoService;
import com.biz.crm.kms.admin.web.reports.vo.DirectStoreReportVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

/**
 * 直营门店报表VO服务接口实现类
 *
 * @author ning.zhang
 * @date 2022/10/12
 */
@Component
@Slf4j
public class DirectStoreReportVoServiceImpl implements DirectStoreReportVoService {

  @Autowired
  private DirectStoreReportVoRepository directStoreReportVoRepository;

  @Override
  public Page<DirectStoreReportVo> findByConditions(Pageable pageable, DirectStoreReportDto dto) {
    pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(1, 50));
    dto = ObjectUtils.defaultIfNull(dto, new DirectStoreReportDto());
    dto.setTenantCode(TenantUtils.getTenantCode());
    dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
    return this.directStoreReportVoRepository.findByConditions(pageable, dto);
  }
}
